﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO; //file müveletek

namespace Labda
{
    public partial class Labdas : Form
    {
        int ures = 0; //"üresjáratok száma"
        int x=130, y=250, r=20, dx=-5, dy=-5; //labda helyzete és elmozdulása
        //int ox=0; //ha az egér mozgási iránya felé mozog a csúszka

        Graphics g; //rajzvászon
        Pen p = new Pen(Color.Blue);
        Brush b = new SolidBrush(Color.LightCoral);
        Image kep, alap; 

        List<Tegla> lista = new List<Tegla>(); //téglákból álló lista
        Tegla csuszka = new Tegla(130, 300, 0, 10);

        public Labdas()
        {
            InitializeComponent();

            kep = new Bitmap(pb.Width, pb.Height);
            pb.Image = kep;
            g = Graphics.FromImage(kep);
            g.Clear(Color.White);            
            alap = new Bitmap(kep); //ez lesz a háttér

            beolvas("szint1.txt");

            rajz();
        }

        void beolvas(string nev)
        {
            lista.Clear(); //kiüríti a listát
            TextReader f = File.OpenText(nev);
            string s = f.ReadLine(); //beolvassa az elsö sort
            int x, y, z, n = Convert.ToInt32(s);
            Tegla A;
            for (int i = 0; i < n; i++)
            {
                s = f.ReadLine(); //olvasok egy sort
                string[] darab = s.Split(' '); //szétszedem darabokra
                x = Convert.ToInt32(darab[0]);
                y = Convert.ToInt32(darab[1]);
                z = Convert.ToInt32(darab[2]);
                A = new Tegla(x, y, z); //új tégla
                lista.Add(A);  //az új elemet a listába pakolja
            }
        }

        void rajz()
        {
            //g.Clear(Color.White); //törlés a háttérszínnel
            g.DrawImage(alap,0,0); //a háttérkép betöltése

            foreach (Tegla A in lista) //minden egyes elemet újrarajzol
            {
                A.Draw(g);    
            }
            label1.Text = "Téglák száma: " + lista.Count;
                        
            g.FillEllipse(b, x, y, r, r);
            g.DrawEllipse(p, x, y, r, r);

            csuszka.Draw(g);

            pb.Refresh();

            if (Erint()==1) rajz();
        }

        int Erint()
        {
            int k=0, //eltüntettem-e valamit
                h = 0, valt=0;
            Tegla A;
            for (int i = lista.Count-1; i >=0; i--)
            {
                h = 0;
                A = lista[i];
                if ( y == A.y2  && (A.x <= x && x <= A.x2 || A.x <= x + r && x + r <= A.x2)) //y szerint lentről
                    { h = 1; 
                      if(valt==0) valt = 1; 
                    }
                else
                    if (y+r == A.y && (A.x <= x && x <= A.x2 || A.x <= x + r && x + r <= A.x2)) //y szerint fentről
                    {
                        h = 1;
                        if (valt == 0) valt = 1;
                    }
                    else
                        if (x == A.x2 && (A.y <= y && y <= A.y2 || A.y <= y + r && y + r <= A.y2)) //x szerint jobbról
                        {
                            h = 1;
                            if (valt == 0) valt = 2;
                        }    
                        else
                            if (x + r == A.x && (A.y <= y && y <= A.y2 || A.y <= y + r && y + r <= A.y2)) //x szerint balról
                            {
                                h = 1;
                                if (valt == 0) valt = 2;
                            }


                if (h == 1) { lista.RemoveAt(i); k = 1; ures = 0; }
            }
            if (valt == 1) dy = -dy;
            else
                if (valt == 2) dx = -dx;

            if (k == 0) ures++;
            return k;
        }


        //ez a "régi" verzió
        void Erint2()
        {
            int k = 1;
            Tegla A;
            for (int i = lista.Count-1; i >=0; i--)
            {
                A = lista[i];
                k = 1;

                if (y == A.y2 && (A.x <= x && x <= A.x2 || A.x <= x+r && x+r <= A.x2))
                {
                    k=0; dy=-dy;
                }
                else
                    if (y+r == A.y && (A.x <= x && x <= A.x2 || A.x <= x+r && x+r <= A.x2))
                    {
                        k = 0; dy = -dy;
                    }
                    else
                        if(x==A.x2 && (A.y <=y && y<=A.y2 || A.y <=y+r && y+r<=A.y2))
                        {
                            k=0; dx=-dx;
                        }
                        else
                            if (x + r == A.x && (A.y <= y && y <= A.y2 || A.y <= y + r && y + r <= A.y2))
                                {
                            k=0; dx=-dx;
                        }
                if (k == 0) lista.RemoveAt(i);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (x + dx < 0) dx = -dx;
            else
                if (y + dy < 0) dy = -dy;
                else
                    if (x + r + dx >= pb.Width) { dx = -dx; x = pb.Width - r - dx; }
                    else
                    {
                        if (y + r == csuszka.y && (csuszka.x <= x && x <= csuszka.x2 ||
                                              csuszka.x <= x + r && x + r <= csuszka.x2))
                        {
                            dy = -dy; 
                        }
                        else
                            if (y + r >= csuszka.y)
                            {
                                timer1.Stop();
                                MessageBox.Show("Vege");
                            }
                    }

                        //if (y + r + dy >= pb.Height) { dy = -dy; y = pb.Height - r-dy; } //also resz pb

            x = x + dx;
            y = y + dy;                        
            
            rajz();

            if (lista.Count == 0)
            {
                timer1.Stop();
                rajz();
                MessageBox.Show("Befejezted!");
            }

            if (ures == 200)
            {
                timer1.Stop();
                MessageBox.Show("Nincs tobb utes");
            }
        }

        private void pb_Click(object sender, EventArgs e)
        {
            //timer1.Enabled = !(timer1.Enabled); //elindítja / megállítja a labdát
        }

        private void pb_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.X < csuszka.sz) //bal szele
            {
                csuszka.x = 0;
                csuszka.x2 = csuszka.sz;
            }
            else
                if (e.X + csuszka.sz/2 >= pb.Width) //jobb szele
                {                    
                    csuszka.x2 = pb.Width-1;
                    csuszka.x = pb.Width-1 - csuszka.sz;
                }
                else //belseje
                {
                    csuszka.x = e.X - csuszka.sz / 2;
                    csuszka.x2 = e.X + csuszka.sz / 2;
                }
            /*
            if (e.X > ox)
            {
                if (csuszka.x2+5 <=pb.Width)
                { //jobbra
                    csuszka.x += 5;
                    csuszka.x2 += 5;
                }
            }
            else
                if (csuszka.x >= 5)
                { //balra

                    csuszka.x -= 5;
                    csuszka.x2 -= 5;
                }
            ox=e.X;
             */
        }

        private void pb_DoubleClick(object sender, EventArgs e)
        {
            x = 130; y = 250;
            timer1.Start();
        }
    }
}
